"""Screen for credits"""


import pygame

import serge.actor
import serge.visual
import serge.events
import serge.common
import serge.blocks.utils
import serge.blocks.visualblocks
import serge.blocks.behaviours
import serge.blocks.actors
import serge.blocks.layout
import serge.blocks.directions
import serge.blocks.effects

from theme import G, theme
import common 

class CreditsScreen(serge.blocks.actors.ScreenActor):
    """The logic for the credits screen"""
    
    
    def __init__(self):
        """Initialise the screen"""
        super(CreditsScreen, self).__init__('item', 'credit-screen')
        self.back = 'start-screen'

    def addedToWorld(self, world):
        """The actor is ready to be populated"""
        super(CreditsScreen, self).addedToWorld(world)
        #
        # Logo
        self.logo = serge.blocks.utils.addSpriteActorToWorld(world, 'logo', 'logo', 
            'logo', 'ui', center_position=G('logo-position'))
        #
        serge.blocks.utils.addVisualActorToWorld(world, 'version', 'version',
            serge.visual.Text('v%s' % common.version, **G('version-text')), 'ui',
            center_position=G('version-text-position'))
        #
        back = serge.blocks.utils.addVisualActorToWorld(world, 'credits', 'credits',
            serge.visual.Text('Back', **G('credits-text')), 'ui',
            center_position=G('credits-text-position'))
        back.linkEvent(serge.events.E_LEFT_CLICK, self.doBack)
        #
        self.bg = serge.blocks.utils.addSpriteActorToWorld(world, 'bg', 'bg', 'credits', 'background', 
            center_position=G('start-bg-position'))
        #

        
    def doBack(self, obj, arg):
        """Back to the start"""
        self.log.info('Clicked on back')
        self.engine.setCurrentWorldByName('start-screen')
        
        
def main(options):
    """Create the main logic"""
    world = serge.engine.CurrentEngine().getWorld('credit-screen')
    #
    # The behaviour manager
    manager = serge.blocks.behaviours.BehaviourManager('behaviours', 'behaviours')
    world.addActor(manager)
    manager.assignBehaviour(None, serge.blocks.behaviours.KeyboardQuit(), 'keyboard-quit')
    #
    # The screen actor
    s = CreditsScreen()
    s.manager = manager
    world.addActor(s)
